require "prefabutil"

local assets = 
{
	Asset("ANIM", "anim/exchangedlife.zip"),
}


local function OnActivate(inst)
	inst.AnimState:PlayAnimation("on",true)
	inst.components.resurrector.active = true
    --ProfileStatsSet("resurrectionstone_activated", true)
	--inst.AnimState:PlayAnimation("activate")
	--inst.AnimState:PushAnimation("idle_activate", true)
	--inst.SoundEmitter:PlaySound("dontstarve/common/resurrectionstone_activate")

	--inst.AnimState:SetLayer( LAYER_WORLD )
	--inst.AnimState:SetSortOrder( 0 )

	--inst.Physics:CollidesWith(COLLISION.CHARACTERS)	
	inst.components.resurrector:OnBuilt()
end

local function makeactive(inst)
	--inst.AnimState:PlayAnimation("idle_activate", true)
	--inst.components.activatable.inactive = false
end

local function makeused(inst)
	--inst.AnimState:PlayAnimation("idle_broken", true)
end

local function doresurrect(inst, dude)
	inst.AnimState:PlayAnimation("off",true)
	inst:AddTag("busy")	
	--inst.MiniMapEntity:SetEnabled(false)
	inst.components.resurrector.active = false
	inst.components.activatable.inactive = true
    --if inst.Physics then
		--MakeInventoryPhysics(inst) -- collides with world, but not character
    --end
    --ProfileStatsSet("resurrectionstone_used", true)

	GetClock():MakeNextDay()
    dude.Transform:SetPosition(inst.Transform:GetWorldPosition())
    dude:Hide()
    TheCamera:SetDistance(12)
	dude.components.hunger:Pause()
	
    scheduler:ExecuteInTime(3, function()
        dude:Show()
        --inst:Hide()

        GetSeasonManager():DoLightningStrike(Vector3(inst.Transform:GetWorldPosition()))


		--inst.SoundEmitter:PlaySound("dontstarve/common/resurrectionstone_break")
        --inst.components.lootdropper:DropLoot()
        SpawnPrefab("exchangedlife").Transform:SetPosition(inst.Transform:GetWorldPosition())
		inst:Remove()
		
        
        if dude.components.hunger then
            dude.components.hunger:SetPercent(0.8)
        end

        if dude.components.health then
            dude.components.health:SetPercent(0.8)--Respawn(TUNING.RESURRECT_HEALTH)
        end
        
        if dude.components.sanity then
			dude.components.sanity:SetPercent(0.8)
        end
        
        dude.components.hunger:Resume()
        
        dude.sg:GoToState("wakeup")
        
        
        dude:DoTaskInTime(3, function(inst) 
		            if dude.HUD then
		                dude.HUD:Show()
		            end
		            TheCamera:SetDefault()
		            inst:RemoveTag("busy")

			--SaveGameIndex:SaveCurrent(function()
			--	end)            
        end)
        
    end)
end

local function onhammered(inst, worker)
	inst:Remove()
end

local function onhit(inst, worker)

end

local function DoIdle(inst)
	inst.components.EMCglobalbuffer:AddFromGlobal(3000)
	if inst.components.EMCglobalbuffer:GetBool(3000*240) then
		OnActivate(inst)
		--if inst.idletask then
			inst.idletask:Cancel()
			inst.idletask = nil
			inst.startedPowering = false
		--end
	end
end

--[[
local function StopIdling(inst)
    if inst.idletask then
        inst.idletask:Cancel()
        inst.idletask = nil
    end
end]]--

local function StartIdling(inst)	
	if not inst.idletask then
		inst.AnimState:PlayAnimation("starting",true)
		inst.SoundEmitter:PlaySound("dontstarve/common/resurrectionstone_activate")
		inst.idletask = inst:DoPeriodicTask(1, DoIdle)
		inst.components.activatable.inactive = false
		inst.startedPowering = true
	end
end

local function OnSave(inst, data)
	data["POW"] = inst.startedPowering
end

local function OnLoad(inst, data)
	inst.startedPowering = data["POW"]
	if inst.startedPowering == true then
		StartIdling(inst)
	elseif inst.components.resurrector.active == true then
		inst.components.activatable.inactive = false
		inst.AnimState:PlayAnimation("on",true)
	end
end


local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()

	--MakeObstaclePhysics(inst, 1)
	--inst.Physics:SetCollisionGroup(COLLISION.OBSTACLES)
	--inst.Physics:ClearCollisionMask()
	--inst.Physics:CollidesWith(COLLISION.WORLD)
	--inst.Physics:CollidesWith(COLLISION.ITEMS)



	anim:SetBank("exchangedlife")
	anim:SetBuild("exchangedlife")
	anim:PlayAnimation("off",true)
	--anim:SetLayer( LAYER_BACKGROUND )
	--anim:SetSortOrder( 3 )
	
	inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
	inst.components.workable:SetWorkLeft(2)
	inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit) 
	

	inst.entity:AddMiniMapEntity()
	
	inst:AddComponent("EMCglobalbuffer")
	inst.components.EMCglobalbuffer.maxEMC = 240*3000

	inst:AddComponent("resurrector")
	inst.components.resurrector.makeactivefn = makeactive
	inst.components.resurrector.makeusedfn = makeused
	inst.components.resurrector.doresurrect = doresurrect
	
	inst.startedPowering = false
	
	inst:AddComponent("activatable")
	inst.components.activatable.OnActivate = StartIdling
	inst.components.activatable.inactive = true
	
	inst.OnSave = OnSave
	inst.OnLoad = OnLoad
	
	inst:AddComponent("inspectable")
	--inst.components.inspectable:RecordViews()
	return inst
end

return Prefab("forest/objects/exchangedlife", fn, assets),
		MakePlacer("common/prefab/exchangedlife_placer", "exchangedlife", "exchangedlife", "starting")
		
